<?php
if (!class_exists('UpiCRMAdminAffiliate')):

    class UpiCRMAdminAffiliate {

        public function __construct() {
            
        }

        public function Render() {
            $UpiCRMFields = new UpiCRMFields();
            $UpiCRMUIBuilder = new UpiCRMUIBuilder();
            $UpiCRMAffiliate = new UpiCRMAffiliate();
            $UpiCRMUsers = new UpiCRMUsers();
            if (isset($_POST['action'])) {
                switch ($_POST['action']) {
                    case 'save_field':
                        $this->saveField();
                        $msg = __('changes saved successfully', 'upicrm');
                        break;
                    case 'save_tree':
                        $this->saveTree();
                        $msg = __('changes saved successfully', 'upicrm');
                        break;
                    case 'edit_link':
                        $this->editLink();
                        $msg = __('changes saved successfully', 'upicrm');
                        break;
                    case 'save_edit_permission':
                        $this->saveEditPermission();
                        $msg = __('changes saved successfully', 'upicrm');
                        break;
                }
                
            }
            ?>

            <div class="row">
                <?php
                if (isset($msg)) {
                    ?>
                    <div class="updated">
                        <p><?php echo $msg; ?></p>
                    </div>
                    <?php
                }
                ?>

            </div>
            <h2><?php _e('Use shortcode', 'upicrm'); ?></h2>
            [upicrm_affiliate]
            <br/><strong><?php _e('OR', 'upicrm'); ?></strong><br/>
            [upicrm_affiliate id="UNIQUE_STRING" field="ID" show="month/no_month" status="Received/Qualified/etc"]
            <br/><strong><?php _e('OR', 'upicrm'); ?></strong><br/>
            [upicrm_affiliate id="UNIQUE_STRING" field="ID" from_month="month (1,2,3 etc)" to_month="month (1,2,3 etc)"]
            <br/><strong><?php _e('OR', 'upicrm'); ?></strong><br/>
            [upicrm_affiliate filter_by="affiliate/assigned_to"]
            <br /><br />
            
            <strong><?php _e('Count leads in table:', 'upicrm'); ?></strong><br />
            [upicrm_affiliate_count id="UNIQUE_STRING"]
            <br /><br />
            
            <strong><?php _e('Export leads:', 'upicrm'); ?></strong><br />
            [upicrm_affiliate_export]
            <br /><br />
            
            <form method="post" action="">
                <h2><?php _e('Edit', 'upicrm'); ?></h2>
                <?php _e('To edit use this shortcode: ', 'upicrm'); ?> [upicrm_affiliate_edit]<br />
                <?php _e('After this insert here the page url where the shortocde is enterd:', 'upicrm'); ?><br />
                <input type="text" placeholder="http://" name="affiliate_edit_link" value="<?php echo @upicrm_clean_data(get_option('upicrm_affiliate_edit_link')); ?>" style="width: 300px;" /><br /><br />
                <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php _e('Save ', 'upicrm'); ?> ">
                <input type="hidden" name="action" value="edit_link" />
            </form>
            <br /><br />
            
            
            <?php require_once @get_upicrm_template_path('affiliates_form'); ?>
            <br /><br />
            <h2><?php _e('Affiliates tree', 'upicrm'); ?></h2>
            <?php require_once @get_upicrm_template_path('affiliates_tree'); ?>
            
            <br /><br />
            <h2><?php _e('Users edit permissions', 'upicrm'); ?></h2>
            <?php
            require_once @get_upicrm_template_path('affiliates_edit');
        }

        function saveField() {
            update_option('upicrm_affiliate_show_fields', upicrm_clean_data($_POST['field']));
        }

        function saveTree() {
            $user_child = (int) $_POST['user_child'];
            $user_parent = (int) $_POST['user_parent'];
            if ($user_parent != $user_child) {
                update_user_meta($user_child, 'affiliate_parent_id', $user_parent);
            }
        }

        function showUserInTree($selectedUser, $users) {
            echo "<li>" . $selectedUser->display_name;
                echo "<ul>";
                foreach ($users as $user) {
                    if ($selectedUser->ID == get_user_meta($user->ID, 'affiliate_parent_id', 1)) {
                        $this->showUserInTree($user, $users);
                    }
                }
                echo "</ul>";
            echo "</li>";
        }
        
        function editLink() {
            update_option('upicrm_affiliate_edit_link', upicrm_clean_data($_POST['affiliate_edit_link']));
        }
        
        function saveEditPermission() {
            $users_arr = [];
            foreach ($_POST['users'] as $id) {
                $users_arr[$id] = (int)$id;
            }
            
            update_option('upicrm_affiliate_edit_permission_users', $users_arr);
        }

    }

    
  
endif;
